<%@ page language="java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>

<%@ taglib prefix="webpath" uri="/WEB-INF/tlds/path.tld"%>
<%@ taglib prefix="webpage" uri="/WEB-INF/tlds/pageview.tld"%>

<head>
	

</head>
		

<div class="main-content">
	<div class="breadcrumbs" id="breadcrumbs">
		

		<ul class="breadcrumb">
			<li>
				<i class="icon-home home-icon"></i>
				<a href="#">首页</a>
			</li>
			<li class="active">礼物管理</li>
		</ul><!-- .breadcrumb -->

		
	</div>
	<div class="page-content">
		<div class="row">
		
			<div class="col-xs-12">
			<div class="widget-toolbox">
				<div class="btn-group">
					<button class="btn btn-sm btn-success" onclick="window.location.href='<webpath:path/>/gift/add'">
						<i class="icon-plus-sign-alt bigger-110"></i>
						新增
					</button>
					
					
				</div>
			</div>
			
			<div class="pull-left"></div>
				<table id="table-data" class="table table-bordered ">
					<thead>
						<tr class="">
							<th>礼物照片</th>
							<th>礼品名称</th>
							<th>详细信息</th>
							<th>礼品积分</th>
							<th>礼品总数</th>
							<th>礼品库存</th>
							<th width="100">操作</th>
						</tr>
					</thead>
		
					<tbody>
					
						<c:forEach var="gift" items="${gifts}">
						<tr class="tr-highlight">
							
							<td title=""><img alt="" src="<webpath:path/>/wx/rainbowplan/loadResource?imageName=${gift.uploadImage}" width="60" height="60"/></td>
							<td title="">${gift.name}</td>
							<td title="">${gift.content}</td>
							<td title="">${gift.point}</td>
							<td title="">${gift.total}</td>
							<td title="">${gift.stock}</td>
							
							<td>
								<div class="visible-md visible-lg hidden-sm hidden-xs btn-group">
									
		
									<button class="btn btn-xs btn-info" onclick="window.location.href='<webpath:path/>/gift/add?id=${gift.id}'">
										<i class="icon-edit bigger-120"></i>
									</button>
									&nbsp;
		
									<button class="btn btn-xs btn-danger" onclick="gift.remove('${gift.id}')">
										<i class="icon-trash bigger-120"></i>
									</button>
		
									
								</div>
		
								
							</td>
						</tr>
						
						</c:forEach>
		
						
					</tbody>
				</table>
											
			</div>
			
		</div>
	</div>
	

</div>

<script src="<webpath:path/>/resources/js/gift/gift.js" type="text/javascript"></script>