package com.qiankun.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.qiankun.dao.PointsTypeDao;
import com.qiankun.entity.PointsType;

@Service
public class PointsService {

	@Autowired
	private PointsTypeDao typeDao;
	
	public PointsType findById(String id) {
		PointsType type = typeDao.find(id);
		return type;
	}

	
	@Transactional
	public PointsType saveType(PointsType type) {
		return typeDao.save(type);		
	}
	
	@Transactional
	public void removeType(String id) {
		typeDao.remove(id);
	}


	 public List<PointsType> findAllType() {
        List<PointsType> list = typeDao.findAll();
        return list;
	}
	 
	 
 
}
