package com.qiankun.controller;
 
import java.io.File;
import java.util.ResourceBundle;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

import com.qiankun.controller.base.BaseController;
import com.qiankun.entity.Gift;
import com.qiankun.service.GiftService;
 
@Controller
public class GiftController extends BaseController<Object>{
 
	@Autowired
	private GiftService giftService;
    
	private ResourceBundle rb = ResourceBundle.getBundle("system");
	private String giftImagePath = File.separator + rb.getString("giftImage");
	
    @RequestMapping("/gift/list")
    public ModelAndView list(HttpServletResponse response, HttpServletRequest request) throws Exception {
        ModelAndView view = new ModelAndView();
		view.getModelMap().addAttribute("gifts", giftService.findAll());
        view.setViewName("gift/list");
        return view;
    }
    
    @RequestMapping("/gift/add")
    public ModelAndView typeAdd(String id) throws Exception {
        ModelAndView view = new ModelAndView();  
        Gift gift = new Gift();
        if(StringUtils.isNotBlank(id)) {
        	gift = giftService.findById(id);      
        }
         
        view.setViewName("gift/save");
        view.getModel().put("gift", gift);
        return view;
    }
    
    @RequestMapping(value = "/gift/save", method = RequestMethod.POST)
	public ModelAndView saveType(@RequestParam(value = "file", required = false) MultipartFile file, Gift gift, HttpServletResponse response, HttpServletRequest request) throws Exception {
    	ModelAndView view = new ModelAndView();
    	
    	Gift g = new Gift();
    	if (StringUtils.isNotEmpty(gift.getId())) {
    		g = giftService.findById(gift.getId());
    		view.getModelMap().addAttribute("status", 2);
    	} else {    		
    		view.getModelMap().addAttribute("status", 1);
    	}
    	
    	g.setName(gift.getName());
    	g.setContent(gift.getContent());
    	g.setStock(gift.getStock());
    	g.setTotal(gift.getTotal());
    	g.setPoint(gift.getPoint());
    	
    	if (file != null) {
        	String fileFullName = file.getOriginalFilename();
        	String[] originalFileName = fileFullName.split("\\.");
        	String fileName = System.currentTimeMillis() + "." + originalFileName[originalFileName.length-1];
            String rootPath = rb.getString("file_path");
            if (StringUtils.isNotBlank(g.getUploadImage())) {
            	File oldFile =  new File(rootPath + g.getUploadImage());
            	if (oldFile.isFile())
            		FileUtils.forceDelete(oldFile);
            }
            
            File destFile = new File(rootPath + giftImagePath,fileName);
            FileUtils.writeByteArrayToFile(destFile,file.getBytes());
            g.setUploadImage(giftImagePath + File.separator + fileName);
        }
    	
    	giftService.save(g);
    	return view;
    	
    }
    
    @RequestMapping("/gift/del")    
    public ModelAndView delActivity(String id,  HttpServletResponse response, HttpServletRequest request) throws Exception {
    	ModelAndView view = new ModelAndView();
    	giftService.remove(id);
    	return view;
    }
    
  
}