package com.qiankun.dao;

import java.util.Date;
import java.util.List;

import org.springframework.stereotype.Repository;

import com.qiankun.dao.core.AbsDao;
import com.qiankun.dao.core.Hints;
import com.qiankun.entity.Activity;
import com.qiankun.pages.IPageList;
import com.qiankun.pages.PageListImpl;

@Repository
public class ActivityDaoImpl extends AbsDao<Activity, String> implements ActivityDao {
	
	
	private static final String FIND_ACTIVITY_PAGE = " from Activity where name like ?  ";
	
	
	@Override
	public IPageList<Activity> findActivityPage(String searchStr, String type, String order, String sort, Hints hints) {
		
		
		if (order == null){
			order = " createTime ";
		}
		if (sort == null){
			sort=" desc ";
		}
		
		String hql = "";
		if (type != null){
			hql = " and type = '" + type + "'";
		}
		
		if (searchStr == null) {
			searchStr = "%";
		}
		String param = "%" + searchStr + "%";
		IPageList<Activity> Activitys = new PageListImpl<Activity>();
		
		Activitys.setRecords(find(FIND_ACTIVITY_PAGE + hql + sortHQL(order, sort), hints, param));
		Activitys.setRecordTotal(findCount(" select count(*) " + FIND_ACTIVITY_PAGE + hql, param));
		
		
		return Activitys;
	}

    @Override
    public List<Activity> findByAvailableAndType(String type) {
	    boolean available = true;
        return find("from Activity where type = ? and available = ? order by createTime desc",new Hints(),type,available);
    }
}
