package com.qiankun.dao;

import com.qiankun.dao.core.AbsDao;
import com.qiankun.dao.core.Hints;
import com.qiankun.entity.Wish;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public class WishDaoImpl extends AbsDao<Wish,String> implements WishDao {
    @Override
    public List<Wish> findByRainbowPlanUserId(String rainbowPlanUserId) {
        return find(" from Wish where rainbowPlanUserId = ? order by createTime desc",new Hints(0),rainbowPlanUserId);
    }

    @Override
    public Wish findById(String id) {
        return findUnique("from Wish where id = ?",new Hints(),id);
    }
}
