package com.qiankun.dao;

import com.qiankun.dao.core.Hints;
import com.qiankun.dao.core.IDao;
import com.qiankun.entity.User;
import com.qiankun.pages.IPageList;

public interface UserDao extends IDao<User, String> {

	IPageList<User> findUserPage(String searchStr, String groupId, String order, String sort, Hints hints);

	User findLastUserByGroup(String groupId);

	User login(String mobile, String password);

	Boolean validateUserExistByMobile(String mobile);

	Boolean validatePwd(String id, String password);

	Boolean validateUserExistByTeamName(String userName);

}
