package com.qiankun.dao;

import com.qiankun.dao.core.Hints;
import com.qiankun.dao.core.IDao;
import com.qiankun.entity.User;
import com.qiankun.pages.IPageList;

public interface UserDao extends IDao<User, String> {

	IPageList<User> findUserPage(String searchStr, String role, String order, String sort, Hints hints);

	User login(String userName, String password);

	Boolean validateUserExistByPaperId(String mobile);

	Boolean validatePwd(String id, String password);

	Boolean validateUserExistByUserName(String userName);

    User findByOpenid(String openid);
}
