package com.qiankun.filter;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang3.StringUtils;


public class EncodingFilter implements Filter {
   
	private static String DEFAULT_ENCODING = "UTF-8";

	private String encoding = null;

	public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {

		if (encoding == null) {
			encoding = DEFAULT_ENCODING;
		}
		request.setCharacterEncoding(encoding);

		chain.doFilter(request, response);     
		
		
		
		
	}

	public String getEncoding() {
		return encoding;
	}

	public void setEncoding(String encoding) {
		this.encoding = encoding;
	}

	public void destroy() {
		
	}

	public void init(FilterConfig fConfig) throws ServletException {
		     
	}   
	

}
