package com.qiankun.controller;
 
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

import com.qiankun.controller.base.BaseController;
 
@Controller
public class WebSiteController extends BaseController<Object>{
 
    @Autowired
    private ApplicationContext applicationContext;
    
    @RequestMapping("/index.html")
    public ModelAndView index() throws Exception {
        ModelAndView view = new ModelAndView();
        view.setViewName("index");
        view.getModelMap().addAttribute("nav", "index");
        return view;
    }
    
    @RequestMapping("/ability.html")
    public ModelAndView ability() throws Exception {
        ModelAndView view = new ModelAndView();
        view.setViewName("ability");
        view.getModelMap().addAttribute("nav", "ability");
        return view;
    }
    
    @RequestMapping("/product.html")
    public ModelAndView product(String id) throws Exception {
        ModelAndView view = new ModelAndView();
        if ("perspective".equals(id)){
        	view.setViewName("perspective");
        } else if ("fictitious".equals(id)){
        	view.setViewName("fictitious");
        } else if ("analysis".equals(id)){
        	view.setViewName("analysis");
        } else {
        	view.setViewName("product");
        }
        
        view.getModelMap().addAttribute("nav", "product");
        return view;
    }
    
    @RequestMapping("/about.html")
    public ModelAndView about() throws Exception {
        ModelAndView view = new ModelAndView();
        view.setViewName("about");
        view.getModelMap().addAttribute("nav", "about");
        return view;
    }
    
    @RequestMapping("/service.html")
    public ModelAndView service() throws Exception {
        ModelAndView view = new ModelAndView();
        view.setViewName("about");
        view.getModelMap().addAttribute("nav", "service");
        return view;
    }

    @RequestMapping("/result")
    public ModelAndView search() throws Exception {
       
        ModelAndView t_view = new ModelAndView();
        return t_view;
    }
    

}