package com.qkdata.common.converter;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.qkdata.common.base.enums.SystemResponseEnum;
import com.qkdata.common.base.exception.BusinessException;
import lombok.extern.slf4j.Slf4j;

import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;

/**
 * 用于@RequestBody中LocalDate类型参数序列化与反序列化
 */
@Slf4j
public class LocalDateDeserializer extends JsonDeserializer<LocalDate> {

    @Override
    public LocalDate deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        try {
            return Instant.ofEpochMilli(p.getLongValue()).atZone(ZoneId.systemDefault()).toLocalDate();
        } catch (Exception e) {
            log.warn("时间转换异常", e);
            throw new BusinessException(SystemResponseEnum.INVALID_TIMESTAMP);
        }

    }

}
