package com.qkdata.common.config;

import com.qkdata.common.converter.StringToCommonEnumConverterFactory;
import com.qkdata.common.converter.StringToLocalDateConverter;
import com.qkdata.common.converter.StringToLocalDateTimeConverter;
import com.qkdata.common.trace.TraceIdInterceptor;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.format.FormatterRegistry;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class WebMvcConfiguration implements WebMvcConfigurer {


    @Override
    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/**")
                .allowedOrigins("*")
                .allowedMethods("*")
                .allowedOrigins("*")
                .allowCredentials(true)
                .maxAge(1800);
    }
    @Override
    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler("swagger-ui.html")
                .addResourceLocations("classpath:/META-INF/resources/");

        registry.addResourceHandler("/webjars/**")
                .addResourceLocations("classpath:/META-INF/resources/webjars/");
    }


    @Override
    public void addFormatters(FormatterRegistry registry) {
        registry.addConverterFactory(stringToEnumConverterFactory());
        registry.addConverter(stringToLocalDateConverter());
        registry.addConverter(stringToLocalDateTimeConverter());
    }

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(traceIdInterceptor());
    }


    private HandlerInterceptor traceIdInterceptor() {
        return new TraceIdInterceptor();
    }



    private ConverterFactory stringToEnumConverterFactory() {
        return new StringToCommonEnumConverterFactory();
    }

    private Converter stringToLocalDateConverter() {
        return new StringToLocalDateConverter();
    }

    private Converter stringToLocalDateTimeConverter() {
        return new StringToLocalDateTimeConverter();
    }
}
