package com.qkdata.common.base.enums;

import com.fasterxml.jackson.annotation.JsonCreator;

/**
 * 删除标志枚举
 */
public enum DeletedEnum implements BasePOEnum {

    DELETED(1, "已删除"),
    NOT_DELETED(2, "未删除");

    private Integer value;

    private String text;

    DeletedEnum(Integer value, String text) {
        this.value = value;
        this.text = text;
    }

    @Override
    public int value() {
        return value;
    }

    @JsonCreator
    public static DeletedEnum valueOf(Integer value) {
        return BasePOEnum.valueOf(DeletedEnum.class, value);
    }
}
