package com.qkdata.biz.wx.controller;

import me.chanjar.weixin.common.bean.WxJsapiSignature;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/wx/jsapi")
public class WxJsApiController {

    @Autowired
    private WxMpService wxMpService;

    @GetMapping("/signature")
    public WxJsapiSignature getSignature(@RequestParam String url) throws WxErrorException {
        return wxMpService.createJsapiSignature(url);
    }
}
