package com.qkdata.biz.sys.controller;

import com.qkdata.biz.sys.entity.SysMenuPO;
import com.qkdata.biz.sys.model.SysNavDTO;
import com.qkdata.biz.sys.service.ShiroService;
import com.qkdata.biz.sys.service.SysMenuService;
import com.qkdata.common.base.exception.BusinessException;
import com.qkdata.common.util.UserContext;
import io.swagger.annotations.Api;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Set;

@Api
@RestController
@RequestMapping("/api/sys/menu")
public class SysMenuController {
    @Autowired
    private SysMenuService sysMenuService;
    @Autowired
    private ShiroService shiroService;

    @GetMapping("/nav")
    public SysNavDTO nav(){
        List<SysMenuPO> menuList = sysMenuService.getUserMenuList(UserContext.getUserId());
        Set<String> permissions = shiroService.getUserPermissions(UserContext.getUserId());
        SysNavDTO navDTO = new SysNavDTO(menuList,permissions);
        return navDTO;
    }
    @GetMapping("/list")
    @RequiresPermissions("sys:menu:list")
    public List<SysMenuPO> list(){
        List<SysMenuPO> menuList = sysMenuService.allList();
        for (SysMenuPO menuPO : menuList){
            SysMenuPO parentMenu = sysMenuService.getById(menuPO.getParentId());
            if (parentMenu != null){
                menuPO.setParentName(parentMenu.getName());
            }
        }
        return menuList;
    }

    @GetMapping("/select")
    @RequiresPermissions("sys:menu:select")
    public List<SysMenuPO> select(){
        List<SysMenuPO> menuList = sysMenuService.queryNotButtonList();

        //添加顶级菜单
        SysMenuPO root = new SysMenuPO();
        root.setId(0L);
        root.setName("一级菜单");
        root.setParentId(-1L);
        root.setOpen(true);
        menuList.add(root);

        return menuList;
    }

    @GetMapping("/info/{id}")
    @RequiresPermissions("sys:menu:info")
    public SysMenuPO info(@PathVariable Long id){
        return sysMenuService.getById(id);
    }

    @PostMapping("/save")
    @RequiresPermissions("sys:menu:save")
    @ResponseStatus(HttpStatus.NO_CONTENT)
    public void save(@RequestBody SysMenuPO sysMenuPO){
        sysMenuService.save(sysMenuPO);
    }
    @PostMapping("/update")
    @RequiresPermissions("sys:menu:update")
    @ResponseStatus(HttpStatus.NO_CONTENT)
    public void update(@RequestBody SysMenuPO sysMenuPO){
        sysMenuService.updateById(sysMenuPO);
    }
    @GetMapping("/delete/{id}")
    @RequiresPermissions("sys:menu:delete")
    @ResponseStatus(HttpStatus.NO_CONTENT)
    public void delete(@PathVariable Long id){
        if (id <= 31){
            throw new BusinessException("系统菜单不能删除");
        }
        //判断是否有子菜单或按钮
        List<SysMenuPO> menuList = sysMenuService.queryListParentId(id);
        if(menuList.size() > 0){
            throw new BusinessException("请先删除子菜单或按钮");
        }
        sysMenuService.deleteById(id);
    }
}
