package com.qkdata.biz.base.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.qkdata.common.base.enums.BasePOEnum;

public enum MenuTypeEnum implements BasePOEnum {
    FOLDER(0,"目录"),MENU(1,"菜单"),BUTTON(3,"按扭");

    MenuTypeEnum(Integer value,String text){
        this.value = value;
        this.text = text;
    }
    private Integer value;
    private String text;
    @Override
    public int value() {
        return value;
    }
    @JsonCreator
    public static MenuTypeEnum valueOf(Integer value) {
        return BasePOEnum.valueOf(MenuTypeEnum.class, value);
    }
}
