package com.qkdata.biz.sys.service;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.qkdata.biz.base.constants.ResultEnum;
import com.qkdata.biz.sys.entity.SysUserPO;
import com.qkdata.biz.sys.model.QueryUserModel;
import com.qkdata.biz.sys.model.SysUserDTO;
import com.qkdata.biz.sys.model.SysUserModel;
import com.qkdata.biz.sys.repository.SysUserMapper;
import com.qkdata.biz.sys.repository.SysUserRoleMapper;
import com.qkdata.common.base.exception.BusinessException;
import com.qkdata.common.base.model.PageDTO;
import com.qkdata.common.base.service.impl.BaseServiceImpl;
import com.qkdata.common.util.UserContext;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.shiro.crypto.hash.Sha256Hash;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.common.Mapper;
import tk.mybatis.mapper.entity.Example;
import tk.mybatis.mapper.util.Sqls;

import java.time.LocalDateTime;
import java.util.List;

@Service
public class SysUserService extends BaseServiceImpl<SysUserPO,Long> {
    @Autowired
    private SysUserMapper sysUserMapper;
    @Autowired
    private SysUserRoleService sysUserRoleService;

    @Override
    protected Mapper<SysUserPO> getMapper() {
        return sysUserMapper;
    }

    @CacheEvict(cacheNames = "user_username",key = "#user.username")
    public void updatePassword(SysUserPO user, String password, String newPassword) {
        //sha256加密
        String pwd = new Sha256Hash(password, UserContext.getUser().getSalt()).toHex();
        if (!user.getPassword().equals(pwd)){
            throw new BusinessException(ResultEnum.PWD_ERROR);
        }
        //sha256加密
        String newPwd = new Sha256Hash(newPassword, UserContext.getUser().getSalt()).toHex();
        user.setPassword(newPwd);
        updateById(user);
    }

    public PageDTO<SysUserDTO> queryPageList(QueryUserModel queryUserModel) {
        PageHelper.startPage(queryUserModel.getPageIndex(),queryUserModel.getPageSize());
        List<SysUserDTO> userList = sysUserMapper.selectByCondition(queryUserModel);
        return new PageDTO<SysUserDTO>(new PageInfo<SysUserDTO>(userList));

    }

    public List<Long> queryRoleIdList(Long userId) {
        return sysUserRoleService.queryRoleIdList(userId);
    }

    public SysUserPO selectByUsername(String username){
        Example query = Example.builder(SysUserPO.class)
            .where(Sqls.custom().andEqualTo("username",username)).build();
        return sysUserMapper.selectOneByExample(query);
    }
    @Transactional
    public void saveUser(SysUserModel sysUserModel) {
        SysUserPO po = selectByUsername(sysUserModel.getUsername());
        if (po != null){
            throw new BusinessException(ResultEnum.ACCOUNT_EXIST);
        }
        po = new SysUserPO();
        BeanUtils.copyProperties(sysUserModel,po);
        po.setCreateAt(LocalDateTime.now());
        po.setSalt(RandomStringUtils.randomAlphanumeric(20));
        po.setPassword(new Sha256Hash(sysUserModel.getPassword(), po.getSalt()).toHex());
        save(po);
        sysUserRoleService.saveOrUpdate(po.getId(),sysUserModel.getRoleIdList());

    }
}
