package com.qkdata.common.base.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.qkdata.common.base.enums.BaseResponseEnum;
import lombok.Data;

import java.io.Serializable;

@SuppressWarnings("deprecation")
@JsonInclude(content = JsonInclude.Include.NON_NULL, value = JsonInclude.Include.NON_EMPTY)
@Data
public class ResponseData implements Serializable {

    private static final long serialVersionUID = 645306359281445009L;

    private String errorCode;

    private String message;

    private Object data;

    public ResponseData() {

    }

    public ResponseData(BaseResponseEnum responseEnum) {
        this.errorCode = responseEnum.value();
        this.message = responseEnum.text();
    }

    public ResponseData(Object data) {
        this.data = data;
    }

    public ResponseData(String code, String message) {
        this.errorCode = code;
        this.message = message;
    }

}
