package com.qkdata.common.base.enums;

public enum SystemResponseEnum implements BaseResponseEnum {

    ERROR("500", "服务器繁忙, 请稍后再试"),
    INVALID_TIMESTAMP("400", "不合法的时间格式"),
    MESSAGE_NOT_READABLE("400", "无法解析请求参数"),
    MISSING_PATH_VARIABLE("400", "请求链接缺少参数"),
    MISSING_REQUEST_PARAM("400", "缺少必需的请求参数"),
    ARGUMENT_TYPE_MISMATCH("400", "参数类别转换失败"),
    CONSTRAINT_VIOLATION("400", "参数校验失败"),
    METHOD_NOT_SUPPORTED("400", "不支持该请求方法"),
    MEDIA_TYPE_NOT_SUPPORTED("400", "不支持该请求参数类型"),
    NO_HANDLER_NOT_FOUND("404", "请求资源不存在");

    private String value;

    private String text;

    SystemResponseEnum(String value, String text) {
        this.value = value;
        this.text = text;
    }

    public String value() {
        return this.value;
    }

    public String text() {
        return this.text;
    }
}
