package com.qkdata.biz.sys.controller;

import com.qkdata.biz.sys.entity.SysMenuPO;
import com.qkdata.biz.sys.model.SysNavDTO;
import com.qkdata.biz.sys.service.ShiroService;
import com.qkdata.biz.sys.service.SysMenuService;
import com.qkdata.common.util.UserContext;
import io.swagger.annotations.Api;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Set;

@Api
@RestController
@RequestMapping("/api/sys/menu")
public class SysMenuController {
    @Autowired
    private SysMenuService sysMenuService;
    @Autowired
    private ShiroService shiroService;

    @GetMapping("/nav")
    public SysNavDTO nav(){
        List<SysMenuPO> menuList = sysMenuService.getUserMenuList(UserContext.getUserId());
        Set<String> permissions = shiroService.getUserPermissions(UserContext.getUserId());
        SysNavDTO navDTO = new SysNavDTO(menuList,permissions);
        return navDTO;
    }
    @GetMapping("/list")
    @RequiresPermissions("sys:menu:list")
    public List<SysMenuPO> list(){
        List<SysMenuPO> menuList = sysMenuService.allList();
        for (SysMenuPO menuPO : menuList){
            SysMenuPO parentMenu = sysMenuService.getById(menuPO.getParentId());
            if (parentMenu != null){
                menuPO.setParentName(parentMenu.getName());
            }
        }
        return menuList;
    }
}
