package com.qkdata.biz.sys.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.qkdata.biz.sys.model.LoginModel;
import com.qkdata.biz.sys.model.LoginUserInfo;
import com.qkdata.biz.sys.service.ShiroService;
import io.swagger.annotations.Api;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

@RestController
@RequestMapping("/api/sys")
@Api
public class SysLoginController {
    @Autowired
    private ShiroService shiroService;


    @PostMapping("/login")
    public LoginUserInfo login(@RequestBody @Valid LoginModel loginModel) throws JsonProcessingException {
        return shiroService.login(loginModel.getUsername(),loginModel.getPassword());
    }

    @GetMapping("/logout")
    @ResponseStatus(HttpStatus.NO_CONTENT)
    public void logout(){
        SecurityUtils.getSubject().logout();
    }
}
