package com.qkdata.common.tree;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author liu_yang
 * 树节点类
 *
 */
public class TreeNode {
	/**
     * <code>id</code> - 节点ID.
     */
    private String m_id;
    /**
     * <code>m_lable</code> - 节点名称.
     */
    private String m_name;
    /**
     * <code>m_icon</code> - 图片.
     */
    private String m_icon;
    /**
     * <code>m_children</code> - 子节点.
     */
    private List<TreeNode> m_children;
    /**
     * <code>m_isExpand</code> - 是否可展开.
     */
    private boolean m_isExpand;
    /**
     * <code>m_isClick</code> - 节点是否可点击.
     */
    private boolean m_isClick;
    /**
     * 节点是否被选中
     */
    private boolean m_isCheck;
    /**
     * <code>m_type</code> - 节点类型.
     */
    private String m_type;
    /**
     * <code>extProperty</code> - {description}.
     */
    private Map<String, String> m_extProperty;

    /**
     * 构造方法.
     *
     * @param id 节点ID.
     * @param values 节点属性集合.
     */
    public TreeNode(final String id, final Map<String, String> values) {
        this.m_id = id;
        this.m_extProperty = values;
    }

    /**
     * @return id - {return content description}
     */
    public String getId() {
        return m_id;
    }

    /**
     * @param id - {parameter description}.
     */
    public void setId(final String id) {
        m_id = id;
    }

    /**
     * @return name - {return content description}
     */
    public String getName() {
        return m_name;
    }

    /**
     * @param name - {parameter description}.
     */
    public void setName(final String name) {
        m_name = name;
    }

    /**
     * @return icon - {return content description}
     */
    public String getIcon() {
        return m_icon;
    }

    /**
     * @param icon - {parameter description}.
     */
    public void setIcon(final String icon) {
        m_icon = icon;
    }

    /**
     * @return children - {return content description}
     */
    public List<TreeNode> getChildren() {
        return m_children;
    }

    /**
     * @param children - {parameter description}.
     */
    public void setChilds(final List<TreeNode> children) {
        m_children = children;
    }

    public boolean getIsCheck() {
		return m_isCheck;
	}

	public void setIsCheck(boolean isCheck) {
		this.m_isCheck = isCheck;
	}

	/**
     * @return isExpand - {return content description}
     */
    public boolean getIsExpand() {
        return m_isExpand;
    }

    /**
     * @param isExpand - {parameter description}.
     */
    public void setIsExpand(final boolean isExpand) {
        m_isExpand = isExpand;
    }

    /**
     * @return isClick - {return content description}
     */
    public boolean getIsClick() {
        return m_isClick;
    }

    /**
     * @param isClick - {parameter description}.
     */
    public void setIsClick(final boolean isClick) {
        m_isClick = isClick;
    }

    /**
     * @return type - {return content description}
     */
    public String getType() {
        return m_type;
    }

    /**
     * @param type - {parameter description}.
     */
    public void setType(final String type) {
        m_type = type;
    }

    /**
     * @return extProperty - {return content description}
     */
    public Map<String, String> getExtProperty() {
        return m_extProperty;
    }

    /**
     * @param extProperty - {parameter description}.
     */
    public void setExtProperty(final Map<String, String> extProperty) {
        m_extProperty = extProperty;
    }

    /**
     * addChild.
     *
     * @param node node
     */
    public void addChild(final TreeNode node) {
        if (this.m_children == null) {
            this.m_children = new ArrayList<TreeNode>();
        }
        m_children.add(node);
    }

}
