package com.qkdata.biz.sys.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import com.qkdata.biz.base.constants.ResultEnum;
import com.qkdata.biz.base.enums.AccountStatusEnum;
import com.qkdata.common.base.exception.BusinessException;
import com.qkdata.common.jwt.JWTService;
import com.qkdata.common.oauth.AuthorizedUser;
import com.qkdata.biz.sys.entity.SysMenuPO;
import com.qkdata.biz.sys.entity.SysUserPO;
import com.qkdata.biz.sys.model.LoginUserInfo;
import com.qkdata.biz.sys.repository.SysMenuMapper;
import com.qkdata.biz.sys.repository.SysUserMapper;
import org.apache.shiro.crypto.hash.Sha256Hash;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.util.*;

@Service
@Transactional(readOnly = true)
public class ShiroService {
    @Autowired
    private SysUserMapper sysUserMapper;
    @Autowired
    private SysMenuMapper sysMenuMapper;
    @Autowired
    private JWTService jwtService;
    private ObjectMapper mapper = new ObjectMapper();

    @Cacheable(cacheNames = "userPerm_userId",unless = "#result == null")
    public Set<String> getUserPermissions(Long userId) {
        List<String> permsList;

        //系统管理员，拥有最高权限
        if(userId == 1){
            List<SysMenuPO> menuList = sysMenuMapper.selectAll();
            permsList = new ArrayList<>(menuList.size());
            for(SysMenuPO menu : menuList){
                permsList.add(menu.getPerms());
            }
        }else{
            permsList = sysUserMapper.queryAllPerms(userId);
        }
        //用户权限列表
        Set<String> permsSet = new HashSet<>();
        for(String perms : permsList){
            if(StringUtils.isEmpty(perms)){
                continue;
            }
            permsSet.addAll(Arrays.asList(perms.trim().split(",")));
        }
        return permsSet;
    }

    @Cacheable(cacheNames = "user_username",unless = "#result == null")
    public SysUserPO getUserByUserName(String username) {
        SysUserPO query = new SysUserPO();
        query.setUsername(username);

        return sysUserMapper.selectOne(query);
    }

    public LoginUserInfo login(String username, String password) throws JsonProcessingException {
        SysUserPO userPO = getUserByUserName(username);
        if(userPO == null || !userPO.getPassword().equals(new Sha256Hash(password, userPO.getSalt()).toHex())) {
            throw new BusinessException(ResultEnum.ACCOUNT_NOT_EXIST);
        }
        if (userPO.getStatus() == AccountStatusEnum.DISABLE){
            throw new BusinessException(ResultEnum.ACCOUNT_OFF);
        }
        String token = generatorToken(userPO);
        LoginUserInfo loginUser = new LoginUserInfo();
        BeanUtils.copyProperties(userPO,loginUser);
        loginUser.setAuthorization(token);
        return loginUser;
    }

    private String generatorToken(SysUserPO userPO) throws JsonProcessingException {
        AuthorizedUser user = new AuthorizedUser();
        user.setUserId(userPO.getId());
        user.setUsername(userPO.getUsername());
        String userJson = mapper.writeValueAsString(user);
        Map<String,Object> userClaim = Maps.newConcurrentMap();
        userClaim.put("user",userJson);
        return jwtService.createJWT(userClaim);

    }
}
