package com.qkdata.biz.sys.controller;

import com.google.common.collect.Lists;
import com.qkdata.biz.sys.entity.SysUserPO;
import com.qkdata.biz.sys.model.SysUserDTO;
import com.qkdata.common.util.UserContext;
import io.swagger.annotations.Api;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@Api
@RestController
@RequestMapping("/api/sys/user")
public class SysUserController {

    @GetMapping("/list")
//    @RequiresPermissions("sys:user:list")
    public List<SysUserPO> list(){
//        SysUserPO user = UserContext.getUser();
        return Lists.newArrayList();
    }

    @GetMapping("/info")
    public SysUserDTO info(){
        SysUserPO userPO =  UserContext.getUser();
        SysUserDTO dto = new SysUserDTO();
        BeanUtils.copyProperties(userPO,dto);
        return dto;
    }
}
