package com.qkdata.common.base.service.impl;


import com.qkdata.common.base.service.BaseService;
import tk.mybatis.mapper.common.Mapper;

import java.util.List;

public abstract class BaseServiceImpl<T, Serializable> implements BaseService<T, Serializable> {

    protected abstract Mapper<T> getMapper();

    @Override
    public T getById(Serializable id) {
        return getMapper().selectByPrimaryKey(id);
    }

    @Override
    public void save(T entity) {
        getMapper().insertSelective(entity);
    }

    @Override
    public void updateById(T entity) {
        getMapper().updateByPrimaryKeySelective(entity);
    }

    @Override
    public List<T> listByCondition(T entity) {
        return getMapper().select(entity);
    }

    @Override
    public T getByCondition(T entity) {
        return getMapper().selectOne(entity);
    }

    @Override
    public int countByCondition(T entity) {
        return getMapper().selectCount(entity);
    }

    @Override
    public void deleteById(Serializable id) {
        getMapper().deleteByPrimaryKey(id);
    }
}
