package com.qkdata.common.base.model;

import com.github.pagehelper.PageInfo;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@Data
@NoArgsConstructor
public class PageDTO<T> implements Serializable {

    /**
    * 
    */
    private static final long serialVersionUID = -3506803903226539566L;

    /**
     * 总条数
     */
    private Long total = 0L;

    /**
     * 数据
     */
    private List<?> result = new ArrayList<>();

    public PageDTO(PageInfo<T> pageInfo) {
        this.total = pageInfo.getTotal();
        List<T> list = pageInfo.getList();
        if (!CollectionUtils.isEmpty(list))
            this.result = pageInfo.getList();
    }

    public PageDTO(PageInfo<T> pageInfo, List<T> result) {
        this.total = pageInfo.getTotal();
        if (!CollectionUtils.isEmpty(result))
            this.result = result;
    }

}
