package com.qkdata.biz.sys.service;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.qkdata.biz.sys.entity.SysRolePO;
import com.qkdata.biz.sys.model.QueryRoleModel;
import com.qkdata.biz.sys.model.SysRoleModel;
import com.qkdata.biz.sys.repository.SysRoleMapper;
import com.qkdata.common.base.exception.BusinessException;
import com.qkdata.common.base.model.PageDTO;
import com.qkdata.common.base.service.impl.BaseServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.common.Mapper;

import java.util.List;

@Service
public class SysRoleService extends BaseServiceImpl<SysRolePO,Long> {

    @Autowired
    private SysRoleMapper sysRoleMapper;
    @Autowired
    private SysRoleMenuService sysRoleMenuService;
    @Autowired
    private SysUserRoleService sysUserRoleService;

    @Override
    protected Mapper<SysRolePO> getMapper() {
        return sysRoleMapper;
    }

    public PageDTO<SysRolePO> queryPageList(QueryRoleModel queryRoleModel) {
        PageHelper.startPage(queryRoleModel.getPageIndex(),queryRoleModel.getPageSize());
        List<SysRolePO> rolePOList =  sysRoleMapper.selectByCondition(queryRoleModel);
        return new PageDTO<>(new PageInfo<>(rolePOList));

    }

    @Transactional
    public void saveRole(SysRoleModel sysRoleModel) {
        SysRolePO po = new SysRolePO();
        BeanUtils.copyProperties(sysRoleModel,po);
        save(po);
        sysRoleMenuService.saveOrUpdate(po.getId(),sysRoleModel.getMenuIdList());
    }

    public SysRoleModel getRoleInfo(Long id) {
        SysRolePO po = getById(id);
        if (po == null){
            throw new BusinessException("请求错误，未找到对应角色");
        }
        List<Long> menuIds = sysRoleMenuService.queryMenuIdList(po.getId());
        SysRoleModel model = new SysRoleModel();
        BeanUtils.copyProperties(po,model);
        model.setMenuIdList(menuIds);
        return model;
    }

    @Transactional
    public void deleteBatch(Long[] ids) {
        sysRoleMapper.deleteByIds(ids);

        sysRoleMenuService.deleteByRoleIds(ids);

        sysUserRoleService.deleteByRoleIds(ids);
    }

    @Transactional
    public void updateRole(SysRoleModel sysRoleModel) {
        SysRolePO po = getById(sysRoleModel.getId());
        if (po == null){
            throw new BusinessException("请求错误，角色不存在");
        }
        po.setName(sysRoleModel.getName());
        po.setRemark(sysRoleModel.getRemark());
        updateById(po);

        sysRoleMenuService.saveOrUpdate(po.getId(),sysRoleModel.getMenuIdList());

    }
}
