package com.qkdata.biz.sys.service;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.qkdata.biz.sys.entity.SysConfigPO;
import com.qkdata.biz.sys.model.QueryConfigModel;
import com.qkdata.biz.sys.repository.SysConfigMapper;
import com.qkdata.common.base.model.PageDTO;
import com.qkdata.common.base.service.impl.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.common.Mapper;

import java.util.List;

@Service
public class SysConfigService extends BaseServiceImpl<SysConfigPO,Long> {
    @Autowired
    private SysConfigMapper sysConfigMapper;

    @Override
    protected Mapper<SysConfigPO> getMapper() {
        return sysConfigMapper;
    }

    public PageDTO<SysConfigPO> queryPageList(QueryConfigModel queryConfigModel) {
        PageHelper.startPage(queryConfigModel.getPageIndex(),queryConfigModel.getPageSize());
        List<SysConfigPO> list = sysConfigMapper.selectByCondition(queryConfigModel);
        return new PageDTO<>(new PageInfo<>(list));
    }

    public void deleteByIds(Long[] ids) {
        sysConfigMapper.deleteByIds(ids);
    }

    public SysConfigPO getByParamKey(String paramKey){
        SysConfigPO query = new SysConfigPO();
        query.setParamKey(paramKey);
        return getByCondition(query);
    }
}
