package com.qkdata.biz.sys.controller;

import com.qkdata.biz.sys.entity.SysConfigPO;
import com.qkdata.biz.sys.model.QueryConfigModel;
import com.qkdata.biz.sys.service.SysConfigService;
import com.qkdata.common.base.model.PageDTO;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.*;

@Api
@RestController
@RequestMapping("/api/sys/config")
public class SysConfigController {
    @Autowired
    private SysConfigService sysConfigService;

    @GetMapping("/list")
    public PageDTO<SysConfigPO> list(QueryConfigModel queryConfigModel){
        return sysConfigService.queryPageList(queryConfigModel);
    }

    @GetMapping("/info/{id}")
    public SysConfigPO info(@PathVariable Long id){
        return sysConfigService.getById(id);
    }

    @PostMapping("/save")
    @ResponseStatus(HttpStatus.NO_CONTENT)
    public void save(@RequestBody SysConfigPO sysConfigPO){
        sysConfigService.save(sysConfigPO);
    }

    @PostMapping("/update")
    @ResponseStatus(HttpStatus.NO_CONTENT)
    public void update(@RequestBody SysConfigPO sysConfigPO){
        sysConfigService.updateById(sysConfigPO);
    }

    @PostMapping("/delete")
    @ResponseStatus(HttpStatus.NO_CONTENT)
    public void delete(@RequestBody Long[] ids){
        sysConfigService.deleteByIds(ids);
    }

}
