package com.qkdata.biz.wx.handler;

import com.qkdata.biz.wx.buider.TextBuilder;
import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.message.WxMpXmlMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutTextMessage;
import me.chanjar.weixin.mp.bean.result.WxMpUser;
import org.springframework.stereotype.Component;

import java.util.Map;

import static me.chanjar.weixin.common.api.WxConsts.XmlMsgType;

/**
 * @author Binary Wang(https://github.com/binarywang)
 */
@Component
@Slf4j
public class MsgHandler extends AbstractHandler {




    @Override
    public WxMpXmlOutMessage handle(WxMpXmlMessage wxMessage,
                                    Map<String, Object> context, WxMpService weixinService,
                                    WxSessionManager sessionManager) {

        if (!wxMessage.getMsgType().equals(XmlMsgType.EVENT)) {
            //TODO 可以选择将消息保存到本地
        }

        String nickName = getNickNameByOpenId(wxMessage.getFromUser(),weixinService);
		try {

	        return new TextBuilder().build("您好，"+nickName+",欢迎关注本公众号。", wxMessage, weixinService);
		} catch (Exception e) {
			WxMpXmlOutTextMessage m = WxMpXmlOutMessage.TEXT().content(e.getMessage())
		            .fromUser(wxMessage.getToUser()).toUser(wxMessage.getFromUser())
		            .build();
			return m;
		}
    }

    private String getNickNameByOpenId(String openId,WxMpService wxMpService) {
        String nickName = "";
        try {
            WxMpUser user = wxMpService.getUserService().userInfo(openId,"zh_CN");
            nickName  = user.getNickname();
        } catch (WxErrorException e) {
            log.error(e.getMessage(),e);
        }
        return nickName;
    }

}
