package com.qkdata.biz.base.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.qkdata.common.base.enums.BasePOEnum;

public enum AccountStatusEnum implements BasePOEnum {
    DISABLE(0, "禁用"), ENABLE(1, "启用");

    private Integer value;

    private String text;

    AccountStatusEnum(Integer value, String text) {
        this.value = value;
        this.text = text;
    }

    @Override
    public int value() {
        return value;
    }

    @JsonCreator
    public static AccountStatusEnum valueOf(Integer value) {
        return BasePOEnum.valueOf(AccountStatusEnum.class, value);
    }
}
