package com.qkdata.biz.sys.controller;

import com.qkdata.biz.sys.entity.SysRolePO;
import com.qkdata.biz.sys.model.QueryRoleModel;
import com.qkdata.biz.sys.model.SysRoleModel;
import com.qkdata.biz.sys.service.SysRoleService;
import com.qkdata.common.base.model.PageDTO;
import io.swagger.annotations.Api;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Api
@RestController
@RequestMapping("/api/sys/role")
public class SysRoleController {
    @Autowired
    private SysRoleService sysRoleService;

    /**
     * 角色列表
     */
    @GetMapping("/select")
    @RequiresPermissions("sys:role:select")
    public List<SysRolePO> select(){
        return sysRoleService.listByCondition(new SysRolePO());
    }

    @GetMapping("/list")
    @RequiresPermissions("sys:role:list")
    public PageDTO<SysRolePO> list(QueryRoleModel queryRoleModel){
        return sysRoleService.queryPageList(queryRoleModel);
    }

    @GetMapping("/info/{id}")
    @RequiresPermissions("sys:role:info")
    public SysRoleModel info(@PathVariable Long id){
        return sysRoleService.getRoleInfo(id);
    }

    @PostMapping("/save")
    @RequiresPermissions("sys:role:save")
    @ResponseStatus(HttpStatus.NO_CONTENT)
    public void save(@RequestBody @Validated SysRoleModel sysRoleModel){
        sysRoleService.saveRole(sysRoleModel);
    }

    @PostMapping("/update")
    @RequiresPermissions("sys:role:update")
    @ResponseStatus(HttpStatus.NO_CONTENT)
    public void update(@RequestBody @Validated SysRoleModel sysRoleModel){
        sysRoleService.updateRole(sysRoleModel);
    }

    @PostMapping("/delete")
    @RequiresPermissions("sys:role:delete")
    @ResponseStatus(HttpStatus.NO_CONTENT)
    public void delete(@RequestBody Long[] ids){
        sysRoleService.deleteBatch(ids);
    }
}
