package com.qkdata.common.util;

import java.util.Objects;
import java.util.function.BiConsumer;

/**
 * 带索引的forEach方法
 */
public class Iterables {

    public static <E> void forEach(Iterable<? extends E> elements, BiConsumer<Integer, ? super E> action) {
        Objects.requireNonNull(elements);
        Objects.requireNonNull(action);

        int index = 0;
        for (E element : elements) {
            action.accept(index++, element);
        }
    }
}
