package com.qkdata.biz.wx.manager.controller;


import com.qkdata.biz.wx.manager.form.TemplateMsgParam;
import io.swagger.annotations.Api;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.template.WxMpTemplateData;
import me.chanjar.weixin.mp.bean.template.WxMpTemplateMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

@RestController
@RequestMapping("/api/wx/manage/templateMsg")
@Api
public class WxTemplateMsgController {

    @Autowired
    private WxMpService wxMpService;

    @Value("${wx.mp.configs[0].templateId}")
    private String templateId;

    @PostMapping("/send")
    public String sendTemplateMsg(@RequestBody TemplateMsgParam param) throws WxErrorException {
        WxMpTemplateMessage templateMessage = WxMpTemplateMessage.builder()
                .toUser(param.getToUser())
                .templateId(templateId)
                .url(param.getUrl())
                .build();
        for (Map.Entry<String,String> entry : param.getParams().entrySet()){
            templateMessage.addData(new WxMpTemplateData(entry.getKey(),entry.getValue()));
        }
        wxMpService.getTemplateMsgService().sendTemplateMsg(templateMessage);
        return "ok";
    }
}
