package com.qkdata.biz.sys.service;

import com.qkdata.biz.sys.entity.SysRoleMenuPO;
import com.qkdata.biz.sys.repository.SysRoleMenuMapper;
import com.qkdata.common.base.service.impl.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import tk.mybatis.mapper.common.Mapper;

import java.util.List;

@Service
public class SysRoleMenuService extends BaseServiceImpl<SysRoleMenuPO,Long> {

    @Autowired
    private SysRoleMenuMapper sysRoleMenuMapper;

    @Override
    protected Mapper<SysRoleMenuPO> getMapper() {
        return sysRoleMenuMapper;
    }

    public void saveOrUpdate(Long roleId, List<Long> menuIdList) {
        deleteByRoleIds(new Long[]{roleId});

        if (CollectionUtils.isEmpty(menuIdList)){
            return;
        }
        for (Long menuId : menuIdList){
            SysRoleMenuPO po = new SysRoleMenuPO();
            po.setRoleId(roleId);
            po.setMenuId(menuId);
            save(po);
        }
    }


    public List<Long> queryMenuIdList(Long roleId) {
        return sysRoleMenuMapper.selectMenuIdsByRoleId(roleId);
    }

    public void deleteByRoleIds(Long[] roleIds) {
        sysRoleMenuMapper.deleteByRoleIds(roleIds);
    }
}
