package com.qkdata.biz.sys.controller;

import com.qkdata.biz.sys.entity.SysUserPO;
import com.qkdata.biz.sys.model.PasswordModel;
import com.qkdata.biz.sys.model.QueryUserModel;
import com.qkdata.biz.sys.model.SysUserDTO;
import com.qkdata.biz.sys.model.SysUserModel;
import com.qkdata.biz.sys.service.SysUserService;
import com.qkdata.common.annotation.SysLog;
import com.qkdata.common.base.exception.BusinessException;
import com.qkdata.common.base.model.PageDTO;
import com.qkdata.common.constants.AddGroup;
import com.qkdata.common.constants.UpdateGroup;
import com.qkdata.common.util.UserContext;
import io.swagger.annotations.Api;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

@Api
@RestController
@RequestMapping("/api/sys/user")
public class SysUserController {
    @Autowired
    private SysUserService sysUserService;

    @SysLog("查询用户列表")
    @GetMapping("/list")
    @RequiresPermissions("sys:user:list")
    public PageDTO<SysUserDTO> list(QueryUserModel queryUserModel){
        return sysUserService.queryPageList(queryUserModel);
    }

    @GetMapping("/info")
    public SysUserDTO info(){
        SysUserPO userPO =  UserContext.getUser();
        SysUserDTO dto = new SysUserDTO();
        BeanUtils.copyProperties(userPO,dto);
        return dto;
    }
    @GetMapping("/info/{id}")
    @RequiresPermissions("sys:user:info")
    public SysUserDTO infoById(@PathVariable Long id){
        SysUserPO sysUserPO = sysUserService.getById(id);
        SysUserDTO dto = new SysUserDTO();
        BeanUtils.copyProperties(sysUserPO,dto);
        dto.setRoleIdList(sysUserService.queryRoleIdList(id));
        return dto;
    }
    @PostMapping("/save")
    @RequiresPermissions("sys:user:save")
    @ResponseStatus(HttpStatus.NO_CONTENT)
    public void save(@RequestBody @Validated(AddGroup.class) SysUserModel sysUserModel){
        sysUserService.saveUser(sysUserModel);
    }
    @PostMapping("/update")
    @RequiresPermissions("sys:user:update")
    @ResponseStatus(HttpStatus.NO_CONTENT)
    public void update(@RequestBody @Validated(UpdateGroup.class) SysUserModel sysUserModel){
        sysUserService.updateUser(sysUserModel);
    }

    /**
     * 修改登录用户密码
     */
    @PostMapping("/password")
    @ResponseStatus(HttpStatus.NO_CONTENT)
    public void password(@RequestBody @Valid PasswordModel form){
        //更新密码
        sysUserService.updatePassword(UserContext.getUser(), form.getPassword(), form.getNewPassword());

    }

    /**
     * 删除用户
     */
    @PostMapping("/delete")
    @RequiresPermissions("sys:user:delete")
    @ResponseStatus(HttpStatus.NO_CONTENT)
    public void delete(@RequestBody Long[] userIds){
        if(ArrayUtils.contains(userIds, 1L)){
            throw new BusinessException("系统管理员不能删除");
        }

        if(ArrayUtils.contains(userIds, UserContext.getUserId())){
            throw new BusinessException("当前用户不能删除");
        }

        sysUserService.deleteBatch(userIds);
    }
}
