package com.qkdata.biz.base.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.qkdata.common.base.enums.BasePOEnum;

public enum SysConfigStatusEnum implements BasePOEnum {
    HIDDEN(0, "隐藏"), SHOW(1, "显示");

    private Integer value;

    private String text;

    SysConfigStatusEnum(Integer value, String text) {
        this.value = value;
        this.text = text;
    }

    @Override
    public int value() {
        return value;
    }

    @JsonCreator
    public static SysConfigStatusEnum valueOf(Integer value) {
        return BasePOEnum.valueOf(SysConfigStatusEnum.class, value);
    }
}
