package com.qkdata.biz.wx.manager.controller;

import io.swagger.annotations.Api;
import me.chanjar.weixin.common.bean.menu.WxMenu;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.menu.WxMpMenu;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@Api
@RestController
@RequestMapping("/api/wx/manage/wxMenu")
public class WxMenuManagerController {

    @Autowired
    private WxMpService wxMpService;

    /**
     * 获取公众号菜单
     */
    @GetMapping("/getMenu")
    public WxMpMenu getMenu() throws WxErrorException {
        WxMpMenu wxMpMenu = wxMpService.getMenuService().menuGet();
        return wxMpMenu;
    }
    /**
     * 创建、更新菜单
     */
    @PostMapping("/updateMenu")
    public void updateMenu(@RequestBody WxMenu wxMenu) throws WxErrorException{
        wxMpService.getMenuService().menuCreate(wxMenu);
    }
}
