package com.qkdata.biz.sys.service;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.qkdata.biz.sys.entity.SysLogPO;
import com.qkdata.biz.sys.model.QueryLogModel;
import com.qkdata.biz.sys.repository.SysLogMapper;
import com.qkdata.common.base.model.PageDTO;
import com.qkdata.common.base.service.impl.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.common.Mapper;

import java.util.List;

@Service
public class SysLogService extends BaseServiceImpl<SysLogPO, Long> {
    @Autowired
    private SysLogMapper sysLogMapper;

    @Override
    protected Mapper<SysLogPO> getMapper() {
        return sysLogMapper;
    }

    public PageDTO<SysLogPO> queryPageList(QueryLogModel queryLogModel) {
        PageHelper.startPage(queryLogModel.getPageIndex(),queryLogModel.getPageSize());
        List<SysLogPO> list = sysLogMapper.selectByCondition(queryLogModel);
        return new PageDTO<>(new PageInfo<>(list));
    }
}
