package com.qkdata.common.tree;

import java.util.List;

/**
 * @author liu_yang
 * 构造树结构时内容提供者接口
 *
 */
public interface IContentProvider {
	/**
     * 获取当前元素下的子元素.
     * 
     * @param curElement 当前元素对象
     * @param level 当前元素级别
     * @param index 当前元素所在层级索引
     * @return 子元素对象集合
     * @throws ServiceException 抛出异常
     */
    List<? extends Object> getChildren(Object curElement, final int level, final int index);

    /**
     * 获取根元素.
     * 
     * @param treeData 树结构所需数据
     * @param level 当前级别
     * @param index 当前索引
     * @return 根元素对象集合
     */
    List<? extends Object> getRootElement(List<? extends Object> treeData, final int level, final int index);

    /**
     * 异步时需实现此方法,用于判断当前元素是否有子元素.
     * 
     * @param curElement 当前元素对象
     * @param level 当前元素级别
     * @param index 当前元素所在层级索引
     * @return true/false
     */
    boolean hasChild(Object curElement, final int level, final int index);
}
