package com.qkdata.common.base.service;

import java.util.List;

/**
 * service基础类
 */
public interface BaseService<T, Serializable> {

    /**
     * 根据主键ID查询
     *
     * @param id
     * @return
     */
    T getById(Serializable id);

    /**
     * 保存
     *
     * @param entity
     */
    void save(T entity);

    /**
     * 根据主键ID更新
     *
     * @param entity
     */
    void updateById(T entity);

    /**
     * 根据指定条件查询列表
     *
     * @param entity
     * @return
     */
    List<T> listByCondition(T entity);

    /**
     * 根据指定条件查询单个实体
     *
     * @param entity
     * @return
     */
    T getByCondition(T entity);

    /**
     * 根据指定条件查询数量
     * @param entity
     * @return
     */
    int countByCondition(T entity);

    void deleteById(Serializable id);
}
