package com.qkdata.common.converter;

import com.qkdata.common.base.enums.BasePOEnum;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.util.StringUtils;

/**
 * 用于QUERY参数转换成对应枚举类型
 */
public class StringToCommonEnumConverterFactory implements ConverterFactory<String, BasePOEnum> {

    @Override
    public <T extends BasePOEnum> Converter<String, T> getConverter(Class<T> targetType) {
        return new StringToEnum<>(targetType);
    }

    private static class StringToEnum<T extends BasePOEnum> implements Converter<String, T> {

        private final Class<T> enumType;

        public StringToEnum(Class<T> enumType) {
            this.enumType = enumType;
        }

        @Override
        public T convert(String source) {
            if (StringUtils.isEmpty(source)) {
                return null;
            }
            return BasePOEnum.getEnum(enumType, Integer.valueOf(source.trim()));
        }
    }

}
