package com.qkdata.common.base.exception;

import com.qkdata.common.base.enums.BaseResponseEnum;
import lombok.Data;

/**
 * 业务异常
 */
@Data
public class BusinessException extends RuntimeException {

    /**
     *
     */
    private static final long serialVersionUID = 4650570427238258122L;

    private String code;
    private String message;

    public BusinessException(BaseResponseEnum responseEnum) {
        this.code = responseEnum.value();
        this.message = responseEnum.text();
    }

    public BusinessException(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public BusinessException() {
        super();
    }

    public BusinessException(String message) {
        super(message);
    }

    public BusinessException(Throwable cause) {
        super(cause);
    }

    public BusinessException(String message, Throwable cause) {
        super(message, cause);
    }

}
