package com.qkdata.biz.sys.service;

import com.qkdata.biz.base.constants.ResultEnum;
import com.qkdata.biz.sys.entity.SysUserPO;
import com.qkdata.biz.sys.repository.SysUserMapper;
import com.qkdata.common.base.exception.BusinessException;
import com.qkdata.common.base.service.impl.BaseServiceImpl;
import com.qkdata.common.util.UserContext;
import org.apache.shiro.crypto.hash.Sha256Hash;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.common.Mapper;

@Service
@Transactional(readOnly = true)
public class SysUserService extends BaseServiceImpl<SysUserPO,Long> {
    @Autowired
    private SysUserMapper sysUserMapper;

    @Override
    protected Mapper<SysUserPO> getMapper() {
        return sysUserMapper;
    }

    @CacheEvict(cacheNames = "user_username",key = "#user.username")
    @Transactional(readOnly = false)
    public void updatePassword(SysUserPO user, String password, String newPassword) {
        //sha256加密
        String pwd = new Sha256Hash(password, UserContext.getUser().getSalt()).toHex();
        if (!user.getPassword().equals(pwd)){
            throw new BusinessException(ResultEnum.PWD_ERROR);
        }
        //sha256加密
        String newPwd = new Sha256Hash(newPassword, UserContext.getUser().getSalt()).toHex();
        user.setPassword(newPwd);
        updateById(user);
    }
}
