package com.qkdata.biz.sys.controller;

import com.google.common.collect.Lists;
import com.qkdata.biz.sys.entity.SysUserPO;
import com.qkdata.biz.sys.model.PasswordModel;
import com.qkdata.biz.sys.model.SysUserDTO;
import com.qkdata.biz.sys.service.SysUserService;
import com.qkdata.common.util.UserContext;
import io.swagger.annotations.Api;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.crypto.hash.Sha256Hash;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

@Api
@RestController
@RequestMapping("/api/sys/user")
public class SysUserController {
    @Autowired
    private SysUserService sysUserService;

    @GetMapping("/list")
//    @RequiresPermissions("sys:user:list")
    public List<SysUserPO> list(){
//        SysUserPO user = UserContext.getUser();
        return Lists.newArrayList();
    }

    @GetMapping("/info")
    public SysUserDTO info(){
        SysUserPO userPO =  UserContext.getUser();
        SysUserDTO dto = new SysUserDTO();
        BeanUtils.copyProperties(userPO,dto);
        return dto;
    }

    /**
     * 修改登录用户密码
     */
    @PostMapping("/password")
    public void password(@RequestBody @Valid PasswordModel form){
        //更新密码
        sysUserService.updatePassword(UserContext.getUser(), form.getPassword(), form.getNewPassword());

    }
}
