package com.qkdata.biz.base.constants;

import com.qkdata.common.base.enums.BaseResponseEnum;

public enum ResultEnum implements BaseResponseEnum {

    ACCOUNT_OFF("14000", "账号已被禁止登录"),
    TOKEN_TIME_OUT("14001", "登录失效，请重新登录"),
    TOKEN_ERROR("14002", "token验证失败"),
    CAPTCHA_ERROR("14004", "验证码错误"),
    MOBILE_ERROR("14005", "手机号不存在"),
    SMS_ERROR("14007", "短信发送失败"),
    ACCOUNT_OR_PWD_ERROR("14008","帐号或密码错误"),
    PWD_ERROR("14009","密码错误");


    private String value;

    private String text;

    ResultEnum(String value, String text) {
        this.value = value;
        this.text = text;
    }

    public String value() {
        return value;
    }

    public String text() {
        return text;
    }

}
