package com.qkdata.common.oauth;


import com.qkdata.common.base.enums.BaseResponseEnum;

public enum AuthorizationResponseEnum implements BaseResponseEnum {

    MISSING_TOKEN("401", "HEADER中不存在TOKEN"),
    INVALID_TOKEN("401", "校验TOKEN失败"),
    EXPIRED_TOKEN("401", "TOKEN已过期"),
    MISSING_CLAIMS("401", "不合法的TOKEN, 信息可能被篡改"),
    INVALID_CLAIM("401", "不合法的TOKEN， 系统中不存在资源");

    private String value;

    private String text;

    AuthorizationResponseEnum(String value, String text) {
        this.value = value;
        this.text = text;
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    public String text() {
        return this.text;
    }
}
