package com.qkdata.biz.sys.controller;

import com.qkdata.biz.sys.entity.SysLogPO;
import com.qkdata.biz.sys.model.QueryLogModel;
import com.qkdata.biz.sys.service.SysLogService;
import com.qkdata.common.base.model.PageDTO;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api
@RestController
@RequestMapping("/api/sys/log")
public class SysLogController {
    @Autowired
    private SysLogService sysLogService;

    @GetMapping("/list")
    public PageDTO<SysLogPO> list(QueryLogModel queryLogModel){
        return sysLogService.queryPageList(queryLogModel);
    }
}
