package com.qkdata.biz.sys.service;

import com.qkdata.biz.sys.entity.SysUserRolePO;
import com.qkdata.biz.sys.repository.SysUserRoleMapper;
import com.qkdata.common.base.service.impl.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import tk.mybatis.mapper.common.Mapper;

import java.util.List;

@Service
public class SysUserRoleService extends BaseServiceImpl<SysUserRolePO,Long> {

    @Autowired
    private SysUserRoleMapper sysUserRoleMapper;

    @Override
    protected Mapper<SysUserRolePO> getMapper() {
        return sysUserRoleMapper;
    }

    public List<Long> queryRoleIdList(Long userId) {
        return sysUserRoleMapper.queryRoleIdList(userId);
    }

    public void saveOrUpdate(Long userId, List<Long> roleIdList) {
        if (!CollectionUtils.isEmpty(roleIdList)){
            //先删除用户与角色关系
            sysUserRoleMapper.deleteByUserId(userId);
            //保存用户角色关系
            for (Long roleId : roleIdList){
                SysUserRolePO po = new SysUserRolePO();
                po.setUserId(userId);
                po.setRoleId(roleId);
                sysUserRoleMapper.insert(po);
            }
        }
    }

    public void deleteByUserIds(Long[] userIds) {
        sysUserRoleMapper.deleteByUserIds(userIds);
    }
}
