package com.qkdata.biz.sys.service;

import com.google.common.collect.Lists;
import com.qkdata.biz.base.constants.Constants;
import com.qkdata.biz.base.enums.MenuTypeEnum;
import com.qkdata.biz.sys.entity.SysMenuPO;
import com.qkdata.biz.sys.repository.SysMenuMapper;
import com.qkdata.biz.sys.repository.SysUserMapper;
import com.qkdata.common.base.service.impl.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.common.Mapper;

import java.util.ArrayList;
import java.util.List;

@Service
public class SysMenuService extends BaseServiceImpl<SysMenuPO,Long> {
    @Autowired
    private SysMenuMapper sysMenuMapper;
    private SysUserMapper sysUserMapper;

    @Override
    protected Mapper<SysMenuPO> getMapper() {
        return sysMenuMapper;
    }
    public List<SysMenuPO> getUserMenuList(Long userId){
        List<SysMenuPO> userMenuList = Lists.newArrayList();
        //系统管理员，拥有最高权限
        if (userId == Constants.SYS_ADMIN_ID){
            userMenuList = getAllMenuList(null);
        }else {
            //用户菜单列表
            List<Long> menuIdList = sysUserMapper.queryAllMenuId(userId);
            userMenuList = getAllMenuList(menuIdList);
        }
        return userMenuList;
    }

    private List<SysMenuPO> getAllMenuList(List<Long> menuIdList) {
        //查询根菜单列表
        List<SysMenuPO> menuList = queryListParentId(0L, menuIdList);
        //递归获取子菜单
        getMenuTreeList(menuList, menuIdList);

        return menuList;
    }

    /**
     * 递归
     */
    private List<SysMenuPO> getMenuTreeList(List<SysMenuPO> menuList, List<Long> menuIdList){
        List<SysMenuPO> subMenuList = Lists.newArrayList();

        for(SysMenuPO entity : menuList){
            //目录
            if(entity.getType() == MenuTypeEnum.FOLDER){
                entity.setList(getMenuTreeList(queryListParentId(entity.getId(), menuIdList), menuIdList));
            }
            subMenuList.add(entity);
        }

        return subMenuList;
    }
    public List<SysMenuPO> queryListParentId(Long parentId) {
        return sysMenuMapper.queryListParentId(parentId);
    }

    private List<SysMenuPO> queryListParentId(Long parentId, List<Long> menuIdList) {
        List<SysMenuPO> menuList = queryListParentId(parentId);
        if(menuIdList == null){
            return menuList;
        }

        List<SysMenuPO> userMenuList = new ArrayList<>();
        for(SysMenuPO menu : menuList){
            if(menuIdList.contains(menu.getId())){
                userMenuList.add(menu);
            }
        }
        return userMenuList;
    }
}
