package com.qkdata.sms;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.util.StringUtils;

import java.util.Arrays;
import java.util.List;
import java.util.stream.LongStream;

import static java.util.stream.Collectors.joining;
import static java.util.stream.Collectors.toList;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertSame;

@RunWith(SpringRunner.class)
public class SplitMobileTest {


    private String singleMobile;

    private String mobiles;

    @Before
    public void before() {
        this.singleMobile = "15822248411";
        this.mobiles = LongStream.range(10000000000L, 19999999999L)
                .limit(100)
                .boxed()
                .map(String::valueOf)
                .collect(joining(","));
        this.mobiles = this.mobiles.replace("10000000000", "");
    }

    @Test
    public void testSplitOfSingleMobile() {
        List<String> mobiles = split(singleMobile);
        assertSame(1, mobiles.size());
        assertEquals("15822248411", mobiles.get(0));
    }

    @Test
    public void testSpliteOfMobiles() {
        List<String> mobiles = split(this.mobiles);
        assertSame(99, mobiles.size());
        assertEquals("10000000001", mobiles.get(0));
        assertEquals("10000000099", mobiles.get(mobiles.size() - 1));
    }

    private List<String> split(String mobile) {
        return Arrays.stream(mobile.split(","))
                .map(String::trim)
                .filter(x -> !StringUtils.isEmpty(x))
                .collect(toList());
    }
}
